/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.uri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.uri.MatchComparator;
import org.glassfish.tyrus.core.uri.internal.PathSegment;
import org.glassfish.tyrus.core.uri.internal.UriComponent;

public class Match {
    private final TyrusEndpointWrapper endpointWrapper;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final List<Integer> variableSegmentIndices = new ArrayList<Integer>();
    private static final Logger LOGGER = Logger.getLogger(Match.class.getName());

    private Match(TyrusEndpointWrapper endpointWrapper) {
        this.endpointWrapper = endpointWrapper;
    }

    List<Integer> getVariableSegmentIndices() {
        return this.variableSegmentIndices;
    }

    int getLowestVariableSegmentIndex() {
        if (this.getVariableSegmentIndices().isEmpty()) {
            return -1;
        }
        return this.getVariableSegmentIndices().get(0);
    }

    void addParameter(String name, String value2, int index2) {
        this.parameters.put(name, value2);
        this.variableSegmentIndices.add(index2);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public TyrusEndpointWrapper getEndpointWrapper() {
        return this.endpointWrapper;
    }

    public String toString() {
        return this.endpointWrapper.getEndpointPath();
    }

    boolean isExact() {
        return this.getLowestVariableSegmentIndex() == -1;
    }

    public static List<Match> getAllMatches(String requestPath, Set<TyrusEndpointWrapper> endpoints, DebugContext debugContext) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (TyrusEndpointWrapper endpoint : endpoints) {
            Match m = Match.matchPath(requestPath, endpoint, debugContext);
            if (m == null) continue;
            matches.add(m);
        }
        Collections.sort(matches, new MatchComparator(debugContext));
        debugContext.appendTraceMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "Endpoints matched to the request URI: ", matches);
        return matches;
    }

    private static Match matchPath(String requestPath, TyrusEndpointWrapper endpoint, DebugContext debugContext) {
        debugContext.appendTraceMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "Matching request URI ", requestPath, " against ", endpoint.getEndpointPath());
        List<PathSegment> requestPathSegments = UriComponent.decodePath(requestPath, true);
        List<PathSegment> endpointPathSegments = UriComponent.decodePath(endpoint.getEndpointPath(), true);
        if (requestPathSegments.size() != endpointPathSegments.size()) {
            debugContext.appendTraceMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "URIs ", requestPath, " and ", endpoint.getEndpointPath(), " have different length");
            return null;
        }
        Match m = new Match(endpoint);
        boolean somethingMatched = false;
        for (int i = 0; i < requestPathSegments.size(); ++i) {
            String endpointSegment;
            String requestSegment = requestPathSegments.get(i).getPath();
            if (requestSegment.equals(endpointSegment = endpointPathSegments.get(i).getPath())) {
                somethingMatched = true;
                continue;
            }
            if (Match.isVariable(endpointSegment)) {
                somethingMatched = true;
                m.addParameter(Match.getVariableName(endpointSegment), requestSegment, i);
                continue;
            }
            debugContext.appendTraceMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "Segment \"", endpointSegment, "\" does not match");
            return null;
        }
        if (somethingMatched) {
            return m;
        }
        return null;
    }

    public static boolean isEquivalent(String path1, String path2) {
        List<String> path1EList = Match.asEquivalenceList(path1);
        List<String> path2EList = Match.asEquivalenceList(path2);
        return path1EList.equals(path2EList);
    }

    private static List<String> asEquivalenceList(String path2) {
        ArrayList<String> equivalenceList = new ArrayList<String>();
        List<PathSegment> segments2 = UriComponent.decodePath(path2, true);
        for (PathSegment next2 : segments2) {
            if (Match.isVariable(next2.getPath())) {
                equivalenceList.add("{x}");
                continue;
            }
            equivalenceList.add(next2.getPath());
        }
        return equivalenceList;
    }

    private static boolean isVariable(String segment) {
        return segment.startsWith("{") && segment.endsWith("}");
    }

    private static String getVariableName(String segment) {
        return segment.substring(1, segment.length() - 1);
    }
}

